package com.example.helloandroid;

import android.app.Activity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.widget.TextView;
import android.widget.Toast;

/**
 * Our second Activity.  This Activity is shown after the user presses the Button located at the bottom of the screen on the first Activity.
 * Here, the text that the user entered is simply displayed to the user, in upper case.
 * 
 * Note that the manifest states that the orientation of this screen must be portrait.
 * 
 * @author Marc J. McDougall
 */
public class Result extends Activity {

	//Class variable that holds a reference to the TextView on the screen
	private TextView result_text;
	
	//Used later to determine how many times the user has pressed the Back button
	private boolean back_pressed_once;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		
		//Must be called at the start of each of the activity life-cycle calls
		super.onCreate(savedInstanceState);
		
		//Sets the view of the screen to the xml resource result.  You can find this resource in the res/layout/ folder
		setContentView(R.layout.result);
		
		//Gets a reference to the result_text TextView
		result_text = (TextView) findViewById(R.id.result_text);
		
		//Note: We initialize all other the variables within onResume() below because we want them to be freshly updated when the user enters
		//or resumes the application.
	}
	
	@Override
	protected void onResume() {
		
		//Must be called at the start of each of the activity life-cycle calls
		super.onResume();
		
		//Initialize the back_pressed value to false
		back_pressed_once = false;
		
		//Sets the text in the TextView equal to the value of the extra String (found by using the same id tag used in Main), and makes it upper case.
		result_text.setText(getIntent().getExtras().getString(Main.TEXT_TAG).toUpperCase());
	}
	
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		
		//When a key is pressed...
		
		//If the key is the Back key...
		if(keyCode == KeyEvent.KEYCODE_BACK){
			
			//If it hasn't been pressed once already...
			if(!back_pressed_once){
				
				//Set the flag to true
				back_pressed_once = true;
				
				//Post a Toast to the user stating that they must press the Button again to exit the Activity
				Toast.makeText(Result.this, "Press back again to exit!", Toast.LENGTH_SHORT).show();
			}
			else{
				
				//If the button was already pressed once, then simply call finish().
				finish();
				
				//Note: finish() is an operating-system level call that stops the Activity currently in the foreground.
			}
			
			
			//Return true.  This tells the operating system that you are handling the event, and not to worry about it
			return true;
		}
		
		//Otherwise, call the super method to get a return value.
		return super.onKeyDown(keyCode, event);
	}
}
